<?php
/*
Template Name: Sign In
Template Post Type: page
*/
is_user_logged_in() ? wp_redirect('/home') : ''; //prevent logged in users

add_filter('body_class', function ($classes) {
    $classes[] = 'sign_1';
    return $classes;
});
get_header();
?>

<main class="sign_in">
    <div class="wrapper">
        <div class="content">
            <div class="wrapper_main">
                <div class="container">
                    <div class="login_page">
                        <div class="title_wrapper">
                            <div class="icon_title">
                                <?php include locate_template('assets/img/icon-title-13.svg'); ?>
                            </div>
                            <h2 class="title"><?php the_title() ?></h2>
                        </div>
                        <div class="sub_title"><?php the_field('subtitle') ?></div>
                        <form data-ajax data-success_redirect="/home" class="box_shadow">
                            <input type="hidden" name="action" value="poker_login">
                            <strong>Username (Player ID)</strong>
                            <input type="text" name="player_id" required>
                            <strong>Password</strong>
                            <input type="password" name="password" required>
                            <strong class="form__info"></strong>
                            <input type="submit" class="btn_form btn" value="Go">
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>




<?php get_footer() ?>
